/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.FluidDrawerInfoGuiAddon;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class FluidDrawerTile
extends ControllableDrawerTile<FluidDrawerTile> {
    public LazyOptional<IFluidHandler> fluidHandlerLazyOptional;
    @Save
    private BigFluidHandler fluidHandler;
    private FunctionalStorage.DrawerType type;

    public FluidDrawerTile(BasicTileBlock<FluidDrawerTile> base, BlockEntityType<FluidDrawerTile> blockEntityType, BlockPos pos, BlockState state, FunctionalStorage.DrawerType type) {
        super(base, blockEntityType, pos, state);
        this.type = type;
        this.fluidHandler = new BigFluidHandler(type.getSlots(), this.getTankCapacity(this.getStorageMultiplier())){

            @Override
            public void onChange() {
                FluidDrawerTile.this.syncObject(FluidDrawerTile.this.fluidHandler);
            }

            @Override
            public boolean isDrawerLocked() {
                return FluidDrawerTile.this.isLocked();
            }

            @Override
            public boolean isDrawerVoid() {
                return FluidDrawerTile.this.isVoid();
            }

            @Override
            public boolean isDrawerCreative() {
                return FluidDrawerTile.this.isCreative();
            }
        };
        this.fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidHandler);
    }

    private int getTankCapacity(int storageMultiplier) {
        long maxCap = (long)(this.type.getSlotAmount() / 64) * 1000L * (long)storageMultiplier;
        return (int)Math.min(Integer.MAX_VALUE, maxCap);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        String slotName = "";
        if (this.type.getSlots() == 2) {
            slotName = "_2";
        }
        if (this.type.getSlots() == 4) {
            slotName = "_4";
        }
        String finalSlotName = slotName;
        this.addGuiAddonFactory(() -> new FluidDrawerInfoGuiAddon(64, 16, new ResourceLocation("functionalstorage", "textures/blocks/fluid_front" + finalSlotName + ".png"), this.type.getSlots(), this.type.getSlotPosition(), this::getFluidHandler, integer -> this.getFluidHandler().getTankCapacity((int)integer)));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public double getStorageDiv() {
        return 2.0;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState stateOwn, FluidDrawerTile blockEntity) {
        super.serverTick(level, pos, stateOwn, blockEntity);
        if (level.m_46467_() % 4L == 0L) {
            block0: for (int i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
                FluidStack drained;
                Direction direction;
                ItemStack stack = this.getUtilityUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Item item = stack.m_41720_();
                if (item.equals(FunctionalStorage.PUSHING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_142300_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(otherFluidHandler -> {
                        for (int tankId = 0; tankId < this.getFluidHandler().getTanks(); ++tankId) {
                            int insertedAmount;
                            FluidStack extracted;
                            BigFluidHandler.CustomFluidTank fluidTank = this.fluidHandler.getTankList()[tankId];
                            if (fluidTank.getFluid().isEmpty() || (extracted = fluidTank.drain(500, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || (insertedAmount = otherFluidHandler.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                            fluidTank.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                            this.fluidHandler.onChange();
                            break;
                        }
                    }));
                }
                if (item.equals(FunctionalStorage.PULLING_UPGRADE.get())) {
                    direction = UpgradeItem.getDirection(stack);
                    TileUtil.getTileEntity((BlockGetter)level, (BlockPos)pos.m_142300_(direction)).ifPresent(blockEntity1 -> blockEntity1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).ifPresent(otherFluidHandler -> {
                        for (int tankId = 0; tankId < this.getFluidHandler().getTanks(); ++tankId) {
                            int insertedAmount;
                            BigFluidHandler.CustomFluidTank fluidTank = this.fluidHandler.getTankList()[tankId];
                            FluidStack extracted = otherFluidHandler.drain(500, IFluidHandler.FluidAction.SIMULATE);
                            if (extracted.isEmpty() || (insertedAmount = fluidTank.fill(extracted, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                            otherFluidHandler.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                            this.fluidHandler.onChange();
                            break;
                        }
                    }));
                }
                if (!item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()) || level.m_46467_() % 20L != 0L) continue;
                direction = UpgradeItem.getDirection(stack);
                FluidState fluidstate = this.f_58857_.m_6425_(this.m_58899_().m_142300_(direction));
                if (fluidstate.m_76178_() || !fluidstate.m_76170_()) continue;
                BlockState state = level.m_8055_(pos.m_142300_(direction));
                Block block = state.m_60734_();
                FluidBlockWrapper targetFluidHandler = null;
                if (block instanceof IFluidBlock) {
                    targetFluidHandler = new FluidBlockWrapper((IFluidBlock)block, level, pos.m_142300_(direction));
                } else if (block instanceof BucketPickup) {
                    targetFluidHandler = new BucketPickupHandlerWrapper((BucketPickup)block, level, pos.m_142300_(direction));
                }
                if (targetFluidHandler == null || (drained = targetFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
                for (int tankId = 0; tankId < this.getFluidHandler().getTanks(); ++tankId) {
                    BigFluidHandler.CustomFluidTank fluidTank = this.fluidHandler.getTankList()[tankId];
                    int insertedAmount = fluidTank.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                    if (insertedAmount != drained.getAmount()) continue;
                    fluidTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                    targetFluidHandler.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                    this.fluidHandler.onChange();
                    continue block0;
                }
            }
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        InteractionResult interactionResult;
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41720_().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.m_41720_().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (slot != -1 && !playerIn.m_21120_(hand).m_41619_() && (interactionResult = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(iFluidHandlerItem -> playerIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
            if (result.isSuccess()) {
                playerIn.m_21008_(playerIn.m_7655_(), result.getResult());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS)) == InteractionResult.SUCCESS) {
            return interactionResult;
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public void onClicked(Player playerIn, int slot) {
        ItemStack stack = playerIn.m_21120_(playerIn.m_7655_());
        if (slot != -1 && !stack.m_41619_()) {
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> playerIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)this.fluidHandler.getTankList()[slot], (IItemHandler)iItemHandler, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
                if (result.isSuccess()) {
                    playerIn.m_21008_(playerIn.m_7655_(), result.getResult());
                }
            }));
        }
    }

    @NotNull
    public FluidDrawerTile getSelf() {
        return this;
    }

    public FunctionalStorage.DrawerType getDrawerType() {
        return this.type;
    }

    @Override
    public int getStorageSlotAmount() {
        return 4;
    }

    @Override
    public int getBaseSize(int lost) {
        return this.type.getSlotAmount();
    }

    public BigFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.fluidHandler.lockHandler();
        this.syncObject(this.fluidHandler);
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getFluidHandler().getTanks(); ++i) {
            if (this.getFluidHandler().getFluidInTank(i).isEmpty()) continue;
            return false;
        }
        if (this.isLocked()) {
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public InventoryComponent<ControllableDrawerTile<FluidDrawerTile>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<FluidDrawerTile>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.m_41720_() instanceof StorageUpgradeItem) {
                    int i;
                    int mult = 1;
                    for (i = 0; i < FluidDrawerTile.this.getStorageUpgrades().getSlots(); ++i) {
                        if (!(FluidDrawerTile.this.getStorageUpgrades().getStackInSlot(i).m_41720_() instanceof StorageUpgradeItem) || i == slot) continue;
                        double calculated = (double)((StorageUpgradeItem)FluidDrawerTile.this.getStorageUpgrades().getStackInSlot(i).m_41720_()).getStorageMultiplier() / FluidDrawerTile.this.getStorageDiv();
                        mult = mult == 1 ? (int)calculated : (int)((double)mult * calculated);
                    }
                    for (i = 0; i < FluidDrawerTile.this.getFluidHandler().getTanks(); ++i) {
                        if (FluidDrawerTile.this.getFluidHandler().getFluidInTank(i).isEmpty() || FluidDrawerTile.this.getFluidHandler().getFluidInTank(i).getAmount() <= FluidDrawerTile.this.getTankCapacity(mult)) continue;
                        return ItemStack.f_41583_;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (stack.m_41720_().equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                return false;
            }
            return stack.m_41720_() instanceof UpgradeItem && ((UpgradeItem)stack.m_41720_()).getType() == UpgradeItem.Type.STORAGE;
        }).setOnSlotChanged((stack, integer) -> {
            this.setNeedsUpgradeCache(true);
            this.fluidHandler.setCapacity(this.getTankCapacity(this.getStorageMultiplier()));
            this.syncObject(this.fluidHandler);
        }).setSlotLimit(1);
    }
}

